using System;
using Server;
using Server.Items;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a black order mage corpse" )] 
	public class TigersClawThief : BaseCreature
	{	
		public override bool ClickTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }

      [Constructable]
		public TigersClawThief() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "black order thief";
			Title = "of the tiger's claw sect";
			Female = Utility.RandomBool();
			Race = Race.Human;
			Hue = Race.RandomSkinHue();
			HairItemID = Race.RandomHair( Female );
			HairHue = Race.RandomHairHue();
			Race.RandomFacialHair( this );
			
			AddItem( new Wakizashi() );
			AddItem( new FancyShirt( 0x51D ) );
			AddItem( new StuddedMempo() );
			AddItem( new JinBaori( 0x69 ) );
			
			Item item;
			
			item = new StuddedGloves();
			item.Hue = 0x69;
			AddItem( item );
			
			item = new LeatherNinjaPants();
			item.Hue = 0x51D;
			AddItem( item );			
			
			item = new LightPlateJingasa();
			item.Hue = 0x51D;
			AddItem( item );
				
			SetStr( 96, 150 );
			SetDex( 50, 105 );
			SetInt( 231, 275 );
			SetHits( 302, 415 );
			
			SetDamage( 10, 33 );			

			SetSkill( SkillName.MagicResist, 45.0, 77.5 );
			SetSkill( SkillName.Magery, 105.0, 120.5 );
			SetSkill( SkillName.Meditation, 75.0, 90.5 );
			SetSkill( SkillName.EvalInt, 105.0, 120.5 );
			SetSkill( SkillName.Wrestling, 75.0, 87.5 );
			SetSkill( SkillName.Tactics, 65.0, 70.5 );

			Fame = 8000;
			Karma = -9000;
			VirtualArmor = 26;
		}

		public TigersClawThief( Serial serial ) : base( serial )
		{
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.SeRich );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
